------- Extra/Bonus Content Unlocker | V1.2 | RE4R/RE9 | by WuhanBiohazard -------

local Game = reframework:get_game_name()
if not Game:find("re[49]") then return end

local JsonName = "Bonus Content Unlocker.json"
local Settings = json.load_file(JsonName)
if not Settings then
	Settings = { UnlockOnly = false }
	json.dump_file(JsonName, Settings)
end

local NeedsSave = false
local function UnlockTableItems(TableList, AltMethod)
	if not TableList then return end	
	local Slot = 0 -- ipairs don't work right
	while TableList[Slot] do
		local Unlockable = TableList[Slot]
		if Unlockable then
			if Game == "re4" then
				if not Unlockable:get_IsUnlock() then Unlockable:setUnlock(true); NeedsSave = true end
				if not Settings.UnlockOnly then
					if not Unlockable:get_IsBuy() then Unlockable:setBuy(true); NeedsSave = true end
				end
			elseif Game == "re9" then
				if AltMethod and AltMethod == 1 then
					if not Unlockable["_PurchaseUnlocked"] then Unlockable["_PurchaseUnlocked"] = true end
					if not Settings.UnlockOnly then			
						if not Unlockable["_Purchased"] then Unlockable["_Purchased"] = true end
					end
				elseif AltMethod and AltMethod == 2 then
					if not Unlockable["_Unlocked"] then Unlockable["_Unlocked"] = true end
				else
					if not Unlockable["_PurchaseUnlocked"] then
						Unlockable:unlockPurchase(); Unlockable["_PurchaseUnlocked"] = true
					end	
					if not Settings.UnlockOnly then				
						if not Unlockable["_AcquisitionUnlocked"] then
							Unlockable:unlockAcquire(); Unlockable["_AcquisitionUnlocked"] = true
						end
						if not Unlockable["_Received"] then
							Unlockable:tryReceived(); Unlockable["_Received"] = true
						end
					end
				end
			end
		end
		Slot = Slot + 1
	end
end
local function SetupBonusItems() -- Make sure unlocked items are actually shown in menus/storage
	if Game == "re4" then
		sdk.get_managed_singleton(sdk.game_namespace("GameRecordManager")):setupBonusItem()
		sdk.get_managed_singleton(sdk.game_namespace("GameRecordManager")):setupBonusWeaponAll()
		sdk.get_managed_singleton(sdk.game_namespace("GameRecordManager")):setBonusUnlockCostume()
	elseif Game == "re9" then
		local RE9SpecialConfig = sdk.get_managed_singleton(sdk.game_namespace("BonusManager")):getSpecialConfigContexts()
		if not RE9SpecialConfig then return end
		local Slot = 0
		while RE9SpecialConfig[Slot] do
			UnlockTableItems(RE9SpecialConfig[Slot]["_ItemDataList"], 2)
			Slot = Slot + 1
		end	
	end
end
local function UnlockExtraDifficulties()
	if Game ~= "re9" then return end
	if not sdk.get_managed_singleton(sdk.game_namespace("GameDifficultyManager")):get_IsUnlockHighestDifficulty() then
		local GameDataManager = sdk.get_managed_singleton(sdk.game_namespace("GameDataManager"))
		if GameDataManager["_TotalClearCount"] == 0 then GameDataManager["_TotalClearCount"] = 1 end
	end
end
local function StartSystemSave()
	if Game ~= "re4" then return end
	sdk.get_managed_singleton("share.SaveDataManager")["_SaveFlowController"]["<CurrPhase>k__BackingField"] = 5
end
local UnlockerRan = false
local function ExtraContentUnlocker()
	if Game == "re4" then
		local RE4ExShopDataList = sdk.get_managed_singleton(sdk.game_namespace("GameRecordManager"))["ExShopDataList"]
		UnlockTableItems(RE4ExShopDataList); if NeedsSave then SetupBonusItems(); StartSystemSave(); NeedsSave = false end
	elseif Game == "re9" then
		local RE9ExShopDataList = sdk.get_managed_singleton(sdk.game_namespace("EXShopManager")):getItemContexts()
		local RE9Artworks = sdk.get_managed_singleton(sdk.game_namespace("BonusManager")):getArtworksItemContexts()
		local RE9Models = sdk.get_managed_singleton(sdk.game_namespace("BonusManager")):getFigureItemContexts()	
		local RE9Bonuses = sdk.get_managed_singleton(sdk.game_namespace("BonusManager")):getBonusContentsContexts()		
		UnlockTableItems(RE9ExShopDataList); UnlockTableItems(RE9Artworks, 1); UnlockTableItems(RE9Models, 1)		
		if not Settings.UnlockOnly then
			UnlockTableItems(RE9Bonuses, 2)
			SetupBonusItems()
			UnlockExtraDifficulties()
		end
	end
	UnlockerRan = true
end

local HookDef; local HookMethod
if Game == "re4" then HookDef = "TitleAnimGuiBehavior"; HookMethod = "onStartOpening" -- Title Screen opening
elseif Game == "re9" then HookDef = "UI1010GuiBehavior"; HookMethod = "onOpenStart" -- Main Menu opening
end
sdk.hook(sdk.find_type_definition(sdk.game_namespace(HookDef)):get_method(HookMethod),
	function() if not UnlockerRan then ExtraContentUnlocker() end end
)